from openai import OpenAI
client = OpenAI(
    base_url="https://api.deepseek.com",
    api_key="$VEI_API_KEY"#此处需要填写个人密钥
)

messages = [
    {"role": "system", "content": "You are a helpful assistant."},
    {"role": "user", "content": "Hello!"}
]

try:
    print("模型回复: ", end="", flush=True)
    response = client.chat.completions.create(
        model="deepseek-chat",
        messages=messages,
        stream=True 
    )
    full_reply = ""
    for chunk in response:
        if chunk.choices and chunk.choices[0].delta.content:
            content = chunk.choices[0].delta.content
            print(content, end="", flush=True)
            full_reply += content
    print()
    messages.append({"role": "assistant", "content": full_reply})

    while True:
        user_input = input("请输入你的问题（输入 'quit' 退出）: ")
        if user_input.lower() == 'quit':
            print("对话结束。")
            break

        messages.append({"role": "user", "content": user_input})

        try:
            print("模型回复: ", end="", flush=True)
            response = client.chat.completions.create(
                model="deepseek-chat",
                messages=messages,
                stream=True 
            )
            full_reply = ""
            for chunk in response:
                if chunk.choices and chunk.choices[0].delta.content:
                    content = chunk.choices[0].delta.content
                    print(content, end="", flush=True)
                    full_reply += content
            print()
            messages.append({"role": "assistant", "content": full_reply})

        except Exception as e:
            print(f"请求发生错误: {e}")

except Exception as e:
    print(f"首次请求发生错误: {e}")